/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.CEADescriptor;
import com.quantumdata.edideditor.CEAVCD;
import com.quantumdata.edideditor.DataBlock;
import com.quantumdata.edideditor.DescriptorType;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEAVideoCapabilityDataBlock
extends DataBlock {
    private ArrayList<CEAVCD> aVCDs = new ArrayList();
    private static final int maxNumDescriptors = 1;
    private static final int descriptorSize = 2;
    private static final int iDatablockSizeInBytes = 3;
    private static final int iVideoCapabilityTag = 7;
    private static final int iVideoCapabilityExtendedTagCode = 0;

    public CEAVideoCapabilityDataBlock() {
        super(2);
        this.iDataBlockTagCode = 7;
    }

    @Override
    public String getDataBlockName() {
        return DescriptorType.VIDEO_CAP_DES.getBlockName();
    }

    @Override
    public String uploadDataBlockData(String string) {
        String string2 = null;
        if (string.length() > 6) {
            return "Video Capability Data Block is too big.";
        }
        super.setHeader(string.substring(0, 2));
        if (Integer.parseInt(string.substring(2, 4), 16) != 0) {
            string2 = "Error parsing Video Capability Data Block";
        } else {
            CEAVCD cEAVCD = new CEAVCD();
            cEAVCD.uploadDescriptorData(string.substring(2, 6));
            this.aVCDs.add(cEAVCD);
        }
        return string2;
    }

    @Override
    public String extractDataBlockData() {
        String string = new String();
        if (this.aVCDs == null || this.aVCDs.size() == 0) {
            string = "Error extracting Video Capability Block Data: No descriptors";
        } else {
            string = string.concat(super.getHeader());
            for (int i = 0; i < this.getCurrentNumDescriptors(); ++i) {
                string = string.concat(this.aVCDs.get(i).extractDescriptorData());
            }
        }
        return string;
    }

    @Override
    public void removeDescriptor(int n) {
        this.aVCDs.remove(n);
    }

    @Override
    public void removeAllDescriptors() {
        this.aVCDs.clear();
        this.adjustNumDescriptors(-1);
    }

    @Override
    public boolean addDescriptor(CEADescriptor cEADescriptor) {
        boolean bl = false;
        if (this.aVCDs == null) {
            this.aVCDs = new ArrayList(1);
        }
        if (this.aVCDs.size() == 1) {
            bl = false;
        } else {
            this.aVCDs.add((CEAVCD)cEADescriptor);
            this.adjustNumDescriptors(1);
            bl = true;
        }
        return bl;
    }

    public ArrayList<CEAVCD> getDescriptors() {
        return this.aVCDs;
    }

    @Override
    public int getDataBlockChecksum() {
        String string = this.extractDataBlockData();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            n2 += Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return n2 & 0xFF;
    }

    public void clearDescriptors() {
        this.aVCDs.clear();
        this.aVCDs = null;
        this.adjustNumDescriptors(0);
    }

    @Override
    public boolean isJustOneCopyAllowed() {
        return true;
    }
}

